// metadata
//
local CMetaData	= OOP_Derive();

// constructor
function CMetaData:__ctor( )
	//
	self.Data = {};
	
end

// parse metadata
function CMetaData:ReadMetaData( filename )
	// was this vmf already parsed?
	if( self.Data[ filename ] ) then return self.Data[ filename ]; end
	
	//
	Msg( filename .. "\n" );
	
	// create our data entry
	local data = {
		author = "N/A",
		description = "N/A",
		author_contact = "N/A",
		steamid = "N/A",
		time = "N/A",
		server = "N/A",
		map = "N/A",
		entities = 0,
	};
	
	// no meta parse?
	if( !VMFSuite.Config['readmeta'] ) then self.Data[ filename ] = data; return data; end

	// read the file.
	local filedata = file.Read( "../" .. filename );
	if( !filedata || string.len( filedata ) <= 0 ) then return data; end
	
	//
	local vmf = VMFSuite.VMF();
	
	//
	vmf:Parse( filedata );
	
	//
	data.entities = vmf:EntityCount();
	

	// find the vmf-global entity
	local global = vmf:FindByClass( "vmf_global" );
	
	// no global, lets use the blank data.
	if( !global ) then 
		
		// Older VMFCopyGun stored the metadata in the worldkey (Actually have forgotten which version this used, but pre 1.2 for sure)
		local v;
		
		// time
		_, v = vmf:FindWorldKey( "time" );
		if( v ) then data.time = tonumber( v ); end
		
		// description
		_, v = vmf:FindWorldKey( "description" );
		if( v ) then data.description = v; end
		
		// server
		_, v = vmf:FindWorldKey( "server" );
		if( v ) then data.server = v; end
		
		// map
		_, v = vmf:FindWorldKey( "map" );
		if( v ) then data.map = v; end
		
		self.Data[ filename ] = data; 
		return data;

	end
	
	//
	local v;
	
	
	// author
	_, v = global:FindKey( "author" );
	if( v ) then data.author = v; end
	
	// description
	_, v = global:FindKey( "description" );
	if( v ) then data.description = v; end
	
	// author contact
	_, v = global:FindKey( "author_contact" );
	if( v ) then data.author_contact = v; end
	
	// steamid
	_, v = global:FindKey( "steamid" );
	if( v ) then data.steamid = v; end
	
	// time
	_, v = global:FindKey( "time" );
	if( v ) then data.time = tonumber( v ); end
	
	// server
	_, v = global:FindKey( "server" );
	if( v ) then data.server = v; end
	
	// map
	_, v = global:FindKey( "map" );
	if( v ) then data.map = v; end
	
	// set
	self.Data[ filename ] = data;
	
	//
	return data;
	
end

//
VMFSuite.MetaDataSystem	= CMetaData:create();

